﻿using System;
using PostitCore;
using PostitCommon;
using System.Collections.Generic;
using Newtonsoft.Json;
using System.Net.Http;

namespace DeXGets
{
    public class LearnerRegistrations : BaseClass
    {
        public class LearnerRegistrations_Response
        {
            public Guid ExternalID;
            public string AdmissionNumber;
            public string UniquePupilNumber;
        }
        /// <summary>
        /// Returns the set of contact contact basics
        /// </summary>
        /// <param name="token"></param>
        /// <param name="key"></param>
        /// <param name="httpClient"></param>
        /// <returns></returns>
        public Dictionary<Guid, LearnerRegistrations_Response> GetValues(string token, string key, HttpClient httpClient)
        {
            Dictionary<Guid, LearnerRegistrations_Response> values = new Dictionary<Guid, LearnerRegistrations_Response>();
            string URL_LearnerRegistration = SetURL("Learner", "LearnerRegistrations?$select=ExternalID,AdmissionNumber,UniquePupilNumber&");
            string resp = DoCall(URL_LearnerRegistration, token, httpClient, key);
            ODataResponse<LearnerRegistrations_Response> learners = null;
            try
            {
                learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LearnerRegistrations_Response>>(resp);
                foreach (LearnerRegistrations_Response s in learners.Value)
                {
                    values.Add(s.ExternalID, s);
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(learners.NextLink))
                {
                    resp = DoCall(GetNextLink(learners.NextLink), token, httpClient, key);
                    learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LearnerRegistrations_Response>>(resp);
                    foreach (LearnerRegistrations_Response s in learners.Value)
                    {
                        values.Add(s.ExternalID, s);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}
